class ReportCommentsController < ApplicationController
  # Let only people with view_reports permission do stuff
  before_action :require_view_reports_permission

  def create
    report_comment = ReportComment.new(report_comment_create_params)

    if report_comment.report_id.blank?
      render(json: {status: 400, message: "You need to provide a report id"}, :status => 200) and return
    end

    if report_comment.comment.blank?
      render(json: {status: 400, message: "You need to provide a comment text"}, :status => 200) and return
    end

    unless Report.find_by(id: report_comment.report_id)
      render(json: {status: 400, message: "You can't comment on a non-existing report"}, :status => 200) and return
    end

    # Set created_by
    report_comment.created_by = current_user.id

    if report_comment.save
      unless request.xhr?
        flash[:success] = "Comment successfully created"
        redirect_to(report_path(id: report_comment.report_id)) and return
      end

      # Get all current comments for this report id
      report_comment_admins = {}
      report_comment_admin_ids = []

      comments = ReportComment.where(report_id: report_comment.report_id).order(id: :asc)
      comments.each do |comment|
        report_comment_admin_ids << comment.created_by
      end
      report_comment_admin_ids = report_comment_admin_ids.uniq

      if report_comment_admin_ids.size > 0
        admins = User.where(id: report_comment_admin_ids).pluck(:id, :email)
        admins.each do |admin|
          report_comment_admins[admin[0]] = admin[1]
        end
      end

      report_comments = []
      comments.each do |c|
        report_comments << {
          id: c.id,
          created_by_username: report_comment_admins[c.created_by],
          comment: c.comment,
          created_at: c.created_at
        }
      end

      render(json: {status: 200, message: "Comment successfully created", comments: report_comments}, :status => 200) and return
    else
      # Some error
      render(json: {status: 500, message: "There was an error creating the comment"}, :status => 200) and return
    end
  end


  private

    def report_comment_create_params
      params.require(:report_comment).permit(
        :report_id,
        :comment
        )
    end

    def require_view_reports_permission
      unless current_user && current_user.has_permission_to?(:view_reports)
        render 'shared/_no_permission' and return
      end
    end
end
