class SuspensionCommentsController < ApplicationController
  # Let only people with view_reports permission do stuff
  before_action :require_view_reports_permission

  def create
    suspension_comment = SuspensionComment.new(suspension_comment_create_params)

    if suspension_comment.suspension_id.blank?
      render(json: {status: 400, message: "You need to provide a suspension id"}, :status => 200) and return
    end

    if suspension_comment.comment.blank?
      render(json: {status: 400, message: "You need to provide a comment text"}, :status => 200) and return
    end

    unless Suspension.find_by(id: suspension_comment.suspension_id)
      render(json: {status: 400, message: "You can't comment on a non-existing suspension"}, :status => 200) and return
    end

    # Set created_by
    suspension_comment.created_by = current_user.id

    if suspension_comment.save
      unless request.xhr?
        flash[:success] = "Comment successfully created"
        redirect_to(suspension_path(id: suspension_comment.suspension_id)) and return
      end

      # Get all current comments for this suspension id
      suspension_comment_admins = {}
      suspension_comment_admin_ids = []

      comments = SuspensionComment.where(suspension_id: suspension_comment.suspension_id).order(id: :asc)
      comments.each do |comment|
        suspension_comment_admin_ids << comment.created_by
      end
      suspension_comment_admin_ids = suspension_comment_admin_ids.uniq

      if suspension_comment_admin_ids.size > 0
        admins = User.where(id: suspension_comment_admin_ids).pluck(:id, :email)
        admins.each do |admin|
          suspension_comment_admins[admin[0]] = admin[1]
        end
      end

      suspension_comments = []
      comments.each do |c|
        suspension_comments << {
          id: c.id,
          created_by_username: suspension_comment_admins[c.created_by],
          comment: c.comment,
          created_at: c.created_at
        }
      end

      render(json: {status: 200, message: "Comment successfully created", comments: suspension_comments}, :status => 200) and return
    else
      # Some error
      render(json: {status: 500, message: "There was an error creating the comment"}, :status => 200) and return
    end
  end


  private

    def suspension_comment_create_params
      params.require(:suspension_comment).permit(
        :suspension_id,
        :comment
        )
    end

    def require_view_reports_permission
      unless current_user && current_user.has_permission_to?(:view_reports)
        render 'shared/_no_permission' and return
      end
    end
end
