class UrlResolverController < ApplicationController
  def index
    if params[:url] && !params[:url].blank?
      # Make sure the initial URL is not an internal one
      unless is_valid_url_for_check(params[:url])
        flash.now[:danger] = "Invalid URL submitted"
        render 'index' and return
      end

      @url_list = []
      current_step = 1
      max_steps = 20
      @end_found = false
      url = params[:url]

      while @end_found == false && current_step <= max_steps  do
         url_info = get_url_info(url)
         unless url_info
            break
         end

         # Set the url to the redirect_url if it exists
         url = url_info[:redirect_url] unless url_info[:redirect_url].blank?

         # Add info about URL to our array
         @url_list << url_info

         current_step = current_step + 1
      end

    end
  end


  private

    def get_url_info(url)
      begin
          url = URI.parse(url)
          http = Net::HTTP.new(url.host, url.port)
          http.use_ssl = true if url.scheme == "https"
          http.open_timeout = 3
          http.read_timeout = 10
          req = Net::HTTP::Head.new(url.request_uri)
          # This way we look real
          req.add_field("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.116 Safari/537.36")
          res = http.request(req)

          if res.code == 200
            @end_found = true
            return {status: res.code, url: url, redirect_url: ""}
          elsif res.is_a?(Net::HTTPRedirection) && res['location']
            # If the next URL would be a Twitch URL we end here
            @end_found = true unless is_valid_url_for_check(res['location'])

            return {status: res.code, url: url, redirect_url: res['location']}
          else
            @end_found = true
            return {status: res.code, url: url, redirect_url: ""}
          end
        rescue Exception => e
          @end_found = true
          return {status: 0, url: url, redirect_url: ""}
      end
    end

    def is_valid_url_for_check(url)
      begin
          parsed_url = URI.parse(url)
        rescue Exception => e
          return false
      end

      if parsed_url.host.nil? || parsed_url.host.match(/justin\.tv$/) || parsed_url.host.match(/twitch\.tv$/) || parsed_url.scheme.nil? || ["http", "https"].include?(parsed_url.scheme) == false
        return false
      end
      return true
    end
end
