module ChatlogsHelper
  def display_badges_from_tags_int(tags_int, room, nick)
    if (tags_int & 128) == 128 # CLEARCHAT
      return '[<span class="glyphicon glyphicon-trash" aria-hidden="true"></span>]'
    end

    tags_string = ""
    tags_array = []
    if (tags_int & 64) == 64
      # Cheer message
      tags_array << 'cheer_message'
    end

    if (tags_int & 32) == 32
      # Subscriber
      tags_array << 'subscriber'
    end

    if (tags_int & 16) == 16
      # Turbo
      tags_array << 'turbo'
    end

    if (tags_int & 8) == 8
      # Staff
      tags_array << 'staff'
    end

    if (tags_int & 4) == 4
      # Admin
      tags_array << 'admin'
    end

    if (tags_int & 2) == 2
      # Global Mod
      tags_array << 'global_mod'
    end

    if (tags_int & 1) == 1
      # Mod
      tags_array << 'mod'
    end

    # Images depending on the tags
    if room.downcase == nick.downcase
      tags_string = tags_string + '<img src="//www-cdn.jtvnw.net/images/xarth/badge_broadcaster.svg" width="18" height="18" alt="[Broadcaster]" title="Broadcaster" style="background-color: #e71818;"> '
    end

    if tags_array.include?('mod')
      tags_string = tags_string + '<img src="//www-cdn.jtvnw.net/images/xarth/badge_mod.svg" width="18" height="18" alt="[Mod]" title="Mod" style="background-color: #34ae0a;"> '
    end

    if tags_array.include?('global_mod')
      tags_string = tags_string + '<img src="//www-cdn.jtvnw.net/images/xarth/badge_globalmod.svg" width="18" height="18" alt="[Global-Mod]" title="Global-Mod" style="background-color: #0c6f20;"> '
    end
    if tags_array.include?('admin')
      tags_string = tags_string + '<img src="//www-cdn.jtvnw.net/images/xarth/badge_admin.svg" width="18" height="18" alt="[Admin]" title="Admin" style="background-color: #faaf19;"> '
    end
    if tags_array.include?('staff')
      tags_string = tags_string + '<img src="//www-cdn.jtvnw.net/images/xarth/badge_staff.svg" width="18" height="18" alt="[Staff]" title="Staff" style="background-color: #200f33;"> '
    end

    if tags_array.include?('turbo')
      tags_string = tags_string + '<img src="//www-cdn.jtvnw.net/images/xarth/badge_turbo.svg" width="18" height="18" alt="[Turbo]" title="Turbo" style="background-color: #6441a5;"> '
    end

    if tags_array.include?('subscriber')
      tags_string = tags_string + '<img src="//static-cdn.jtvnw.net/jtv_user_pictures/subscriber-star.png" width="16" height="16" alt="[Subscriber]" title="Subscriber" style="background-color: #fff; border:1px solid #000;"> '
    end

    if tags_array.include?('cheer_message')
      tags_string = tags_string + '<img src="//static-cdn.jtvnw.net/bits/light/animated/red/1" width="18" height="18" alt="[Cheer-Message]" title="Cheer-Message">'
    end

    tags_string = tags_string.strip
    if !tags_string.blank?
      tags_string = "[#{tags_string}]"
    end

    return tags_string
  end

  def display_tags_from_tags_int(tags_int, room, nick)
    tags_string = ""
    tags_array = []
    if (tags_int & 64) == 64
      # Subscriber
      tags_array << 'cheer_message'
    end

    if (tags_int & 32) == 32
      # Subscriber
      tags_array << 'subscriber'
    end

    if (tags_int & 16) == 16
      # Turbo
      tags_array << 'turbo'
    end

    if (tags_int & 8) == 8
      # Staff
      tags_array << 'staff'
    end

    if (tags_int & 4) == 4
      # Admin
      tags_array << 'admin'
    end

    if (tags_int & 2) == 2
      # Global Mod
      tags_array << 'global_mod'
    end

    if (tags_int & 1) == 1
      # Mod
      tags_array << 'mod'
    end

    # Images depending on the tags
    if room.downcase == nick.downcase
      tags_string = tags_string + '[Broadcaster] '
    end

    if tags_array.include?('mod')
      tags_string = tags_string + '[Mod] '
    end

    if tags_array.include?('global_mod')
      tags_string = tags_string + '[Global-Mod] '
    end
    if tags_array.include?('admin')
      tags_string = tags_string + '[Admin] '
    end
    if tags_array.include?('staff')
      tags_string = tags_string + '[Staff] '
    end

    if tags_array.include?('turbo')
      tags_string = tags_string + '[Turbo] '
    end

    if tags_array.include?('subscriber')
      tags_string = tags_string + '[Subscriber] '
    end

    if tags_array.include?('cheer_message')
      tags_string = tags_string + '[Cheer-Message]'
    end

    tags_string = tags_string.strip
    if !tags_string.blank?
      tags_string = "[#{tags_string}]    "
    end

    return tags_string
  end

  def format_timestamp(timestamp)
    Time.at(timestamp).to_datetime.in_time_zone("America/Los_Angeles").strftime("%Y-%m-%d %I:%M:%S %p %Z")
  end

  def report_description_string(line)
    line_string = "#{format_timestamp(line[:timestamp])}    #{line[:room]}"
    unless line[:room_id].blank?
      line_string = "#{line_string} (#{line[:room_id]})"
    end
    line_string = "#{line_string}    #{display_tags_from_tags_int(line[:tags_int], line[:room].to_s[1..-1], line[:nick].to_s)}#{line[:nick]}"
    unless line[:nick_id].blank?
      line_string = "#{line_string} (#{line[:nick_id]})"
    end
    line_string ="#{line_string}    #{line[:message]}"

    return line_string
  end

  def parse_clearchat_message(message)
    msg = ""
    # Timeout
    if message[0..12] == "ban-duration=" # /timeout
      # Get duration
      pos = message.index(";") - 1
      msg = "#{msg}Timeout for #{message[13..pos]} seconds"
    elsif message.blank? # /clear
      msg = "#{msg}History cleared (/clear)"
    else # /ban
      msg = "#{msg}Ban"
    end

    # Check for reason msg
    if pos = message.index("ban-reason=")
      reason_msg = message[pos+11..-1].strip
      unless reason_msg.blank?
        msg = "#{msg} for: \"#{reason_msg.gsub('\s',' ')}\""
      end
    end

    return msg
  end
end
