class AutoResolve < ActiveRecord::Base
  validates :content, presence: true, inclusion: { in: %w(channel_feed_post_report channel_feed_comment_report clip_report user_report vod_comment_report vod_report whisper_report) }


  # Returns 1 for yes (resolve),
  #         0 for not matched (aka not resolve),
  #        -1 for don't resolve this report even if other auto resolves match
  def resolves?(from_user_id, target_user_id, content)
    # Sanity check for input values
    if from_user_id.nil? || target_user_id.nil? || content.nil?
      return 0
    end

    # Check if the AutoResolve is disabled or run out
    if !self.disabled_at.nil? || (!self.resolve_until.nil? && Time.now.to_i > Time.at(self.resolve_until).to_i)
      return 0
    end


    # Check if content matches
    if self.content != content
      return 0
    end


    # Only from_user_id
    if !self.from_user_id.nil? && self.target_user_id.nil?
      if self.from_user_id > 0
        if self.from_user_id == from_user_id
          return 1
        else
          return 0
        end
      elsif self.from_user_id < 0
        if self.from_user_id.abs == from_user_id
          return -1
        else
          return 0
        end
      end
    end

    # Only target_user_id
    if self.from_user_id.nil? && !self.target_user_id.nil?
      if self.target_user_id > 0
        if self.target_user_id == target_user_id
          return 1
        else
          return 0
        end
      elsif self.target_user_id < 0
        if self.target_user_id.abs == target_user_id
          return -1
        else
          return 0
        end
      end
    end

    # from_user_id and target_user_id
    if !self.from_user_id.nil? && !self.target_user_id.nil?
      # Everything is positive so it's a match check
      if self.from_user_id > 0 && self.target_user_id > 0
        if self.from_user_id == from_user_id && self.target_user_id == target_user_id
          return 1
        else
          return 0
        end
      # from_user_id is negative
      elsif self.from_user_id < 0 && self.target_user_id > 0
        if self.from_user_id.abs == from_user_id && self.target_user_id == target_user_id
          return -1
        else
          return 0
        end
      # target_user_id is negative
      elsif self.from_user_id > 0 && self.target_user_id < 0
        if self.from_user_id == from_user_id && self.target_user_id.abs == target_user_id
          return -1
        else
          return 0
        end
      else
        # Can only be both negative (which would resolve all reports except for this combo, that would be bad)
        return 0
      end
    end

    # We shouldn't get here because all normal cases have been matched but if we do just return not resolve
    return 0
  end
end
