require 'active_record/diff'

class Report < ActiveRecord::Base
  include ActiveRecord::Diff
  diff :exclude => [:created_at, :updated_at]

  validates :status, presence: true, inclusion: { in: %w(new open resolved) }
  validates :assigned_to, numericality: { only_integer: true, allow_nil: true }

  # PS 4 reports don't need to have this info
  #validates :from_user_username, presence: true, format: { with: /\A[a-z0-9_]+\z/ }
  #validates :from_user_id, presence: true, numericality: { only_integer: true }
  #validates :from_user_type, presence: true, inclusion: { in: %w(user global_mod admin staff) }
  #validates :from_user_partner, inclusion: { in: [true, false] }

  validates :target_user_username, presence: true, format: { with: /\A[a-z0-9_]+\z/ }
  validates :target_user_id, presence: true, numericality: { only_integer: true }
  validates :target_user_type, presence: true, inclusion: { in: %w(user global_mod admin staff) }
  validates :target_user_partner, inclusion: { in: [true, false] }

  validates :content, presence: true, inclusion: { in: %w(channel_feed_post_report channel_feed_comment_report clip_report user_report vod_comment_report vod_report whisper_report) }
  validates :reason, presence: true, inclusion: { in: %w(bits_violation chat_ban_evasion cheating creative_conduct gore harassment harm hate_speech impersonation music_conduct nongaming offensive_username other porn prohibited selfharm social_eating_violation spam tos_ban_evasion underaged) }
  validates :description, presence: true

end
