require 'active_record/diff'

class SuspensionGuide < ActiveRecord::Base
  include ActiveRecord::Diff
  diff :exclude => [:created_at, :updated_at]

  before_save { self.detailed_reason_title = detailed_reason_title.strip }
  before_save { self.detailed_reason_description = detailed_reason_description.strip.gsub(/\r\n/, "\n").gsub(/\r/, "\n") }
  before_save { self.strike_details = strike_details.strip.gsub(/\r\n/, "\n").gsub(/\r/, "\n") }
  before_save { self.strike_form_note = strike_form_note.strip.gsub(/\r\n/, "\n").gsub(/\r/, "\n") }
  before_save { self.offense_send_to_user = offense_send_to_user.strip.gsub(/\r\n/, "\n").gsub(/\r/, "\n") }
  before_save { self.violated_tos_section = violated_tos_section.strip.gsub(/\r\n/, "\n").gsub(/\r/, "\n") }

  validates :ignore, inclusion: { in: [true, false] }
  validates :sorting, numericality: { only_integer: true, allow_nil: true }
  validates :content_id, numericality: { only_integer: true }
  validates :reason_id, numericality: { only_integer: true }
  validates :detailed_reason_id, numericality: { only_integer: true }
  validates :detailed_reason_title, presence: true
  # validates :detailed_reason_description, presence: true
  validates :strike_details, presence: true
  validates :ip_ban, inclusion: { in: [true, false] }
  validates :permanent, inclusion: { in: [true, false] }
  validates :clear_images, inclusion: { in: [true, false] }
  # validates :strike_form_note, presence: true
  validates :remove_offending_content, inclusion: { in: [true, false] }
  validates :escalate, inclusion: { in: [true, false] }
  validates :list_in_quick_select, inclusion: { in: [true, false] }

end
