require 'active_record/diff'

class SuspensionGuideReason < ActiveRecord::Base
  include ActiveRecord::Diff
  diff :exclude => [:created_at, :updated_at]

  before_save { self.reason = reason.downcase.strip }
  before_save { self.reason_description = reason_description.strip }
  validates :reason, presence: true, uniqueness: { case_sensitive: false }, format: { with: /\A[a-z0-9_]+\z/ }
  validates :reason_description, presence: true

end
