require 'net/http'

class TwitchChannelsService

  def self.get_channel_by_username(username, no_cache = false)
   if username.blank?
      return nil
    end

    # Case sensitivity doesn't matter for Twitch so we downcase it
    username = username.downcase.strip

    # Check if we have it already cached
    unless no_cache
      cache = $redis.get("TwitchChannelsService:username:#{username}")
      if cache
        return JSON.parse(cache)
      end
    end

    # Do the api request
    url = URI.parse("http://channels.prod.us-west2.twitch.tv/channels?name=#{URI::escape(username)}")
    http = Net::HTTP.new(url.host, url.port)
    http.use_ssl = true if url.scheme == "https"
    http.open_timeout = 1
    http.read_timeout = 3
    req = Net::HTTP::Get.new(url.request_uri)
    res = http.request(req)

    unless res.is_a?(Net::HTTPSuccess)
      raise "Twitch API error"
    end

    res_hash = JSON.parse(res.body)
    if !res_hash["results"].empty? && res_hash["results"][0]["name"] == username
      # Gen hash with only the info we need
      channel_hash = {}
      channel_hash["game"] = res_hash["results"][0]["game"]
      channel_hash["game_id"] = res_hash["results"][0]["game_id"]
      channel_hash["status"] = res_hash["results"][0]["status"]

      unless no_cache
        cache_channel(username, channel_hash)
      end

      return channel_hash
    else
      raise "Channel not found"
    end
  end

  def self.cache_channel(username, channel_hash)
    if username.empty?
      return
    end

    # Set ID => Username
    $redis.setex("TwitchChannelsService:username:#{username}", 5.minutes, channel_hash.to_json)
  end
end
