require 'net/http'

class TwitchPartnershipsService

  def self.get_partner_by_id(id, no_cache = false)
    if id == nil
      return nil
    end

    # Negative IDs to positive
    if id < 0
      id = id.abs
    end

    # Check if we have it already cached
    unless no_cache
      cache = $redis.get("TwitchPartnershipsService:id:#{id}")
      if cache
        return cache
      end
    end

    # Do the api request
    url = URI.parse("http://partnerships.prod.us-west2.twitch.tv/partners/#{id}/properties")
    http = Net::HTTP.new(url.host, url.port)
    http.use_ssl = true if url.scheme == "https"
    http.open_timeout = 1
    http.read_timeout = 3
    req = Net::HTTP::Get.new(url.request_uri)
    res = http.request(req)

    unless res.is_a?(Net::HTTPSuccess)
      raise "Twitch API error"
    end

    res_hash = JSON.parse(res.body)
    if res_hash["user_id"] == id
      if res_hash["partner_program"] == true
        partnership = "true"
      else
        partnership = "false"
      end

      unless no_cache
        cache_id(id, partnership)
      end

      return partnership
    end
    raise "ID not found"
  end

  def self.cache_id(id, partnership)
    if id.blank?
      return
    end

    # Set ID => Username
    $redis.setex("TwitchPartnershipsService:id:#{id}", 15.minutes, partnership)
  end
end
