OmniAuth.config.logger = Rails.logger
OmniAuth.configure do |config|
  # Always use /auth/failure in any environment.
  config.failure_raise_out_environments = []
  config.full_host = "https://leviathan.moderation.twitch.tv" if Rails.env.production?
end

Rails.application.config.middleware.use OmniAuth::Builder do
  provider :google_oauth2, ENV["GOOGLE_CLIENT_ID"], ENV["GOOGLE_CLIENT_SECRET"], {
    scope: "email", # We don't do anything with the google account except checking the email
    hd: %w(mods.twitch.tv justin.tv twitch.tv), # Only allow these email domains
    access_type: :online # No need to use "offline" because we don't do any request after login
  }
end
