# API

| Action                                    | Response     |     Method      | URL                                                       |
|-------------------------------------------|:------------:|:---------------:|:----------------------------------------------------------|
| [Create Reports](/docs/api.md/#create-reports)          | JSON         | POST             | /reports |

## Create Reports

This API allows you to create different types of reports.

Required Parameters:
* **authorisation_token**
  * This is to make sure your service is allowed to create a report
* **report[from_user_id] or report[from_user_username]**
  * user id (int) is preferred, if both are provided id is used. If there is no reporter (should only be happening on PS4) then this can be skipped
* **report[target_user_id] or report[target_user_username]**
  * user id (int) is preferred, if both are provided id is used.
* **report[content]**
  * This is one of these (channel_feed_post_report, channel_feed_comment_report, clip_report, user_report, vod_comment_report, vod_report, whisper_report)
* **report[reason]**
  * This is one of these (bits_violation, chat_ban_evasion, cheating, creative_conduct, gore, harassment, harm, hate_speech, impersonation, music_conduct, nongaming, offensive_username, other, porn, prohibited, selfharm, social_eating_violation, spam, tos_ban_evasion, underaged)
* **report[description]**
  * Either the reporting users description of the violation or a "copy pasta" of the reported content for whisper reports and channel feed reports

Semi optional parameters:
* **report[content_id]**
  * The content "ID" for certain report types (channel/slug for clip reports, post ID for channel feed post reports, comment ID for channel feed comment reports, VOD ID for VOD reports)
* **report[extra1]**
  * For either the feed owner user ID on channel feed comment reports, the timestamp on VOD reports or the VOD ID on vod comment reports
* **report[origin]**
  * Your repo like "web/web" (in case there are issues with the reports so we can contact you)
