

module "bs-staging" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "fuel-devportal-dev"
  eb_application_name = "tachanka"
  vpc_id = "dev-vpc"
  ec2_subnet_ids = "dev-sbs"
  elb_subnet_ids = "dev-sbs"
  elb_loadbalancer_security_groups = "dev-sgs"
  auto_scaling_lc_security_groups = "dev-sgs"
  solution_stack_name = "64bit Amazon Linux 2016.09 v2.3.0 running Docker 1.11.2"
  auto_scaling_lc_keypair_name = "dev-devtools-dta"
  auto_scaling_lc_instance_type = "t2.micro"
  owner = "fuel-devportal@amazon.com"
  service = "commerce/tachanka"
  env = "staging"
  associate_public_address = "false"
  cname_prefix = "test-staging"
}
