variable "aws_credentials" {
  type = "string"
  default = "fuel-devportal-prod"
}

variable "service_name" {
  default = "tachanka"
}

module "aws_account" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/systems/terraform.git//modules/account_template/region/us-west-2?ref=master"
  region = "us-west-2"
  account_name = "fuel-devportal@amazon.com"
  vpc_cidr = "10.201.56.0/22"
  account_id = "961823875659"
  owner = "fuel-devportal@amazon.com"
  service = "${var.service_name}"
  environment = "production"
  credential_profile="${var.aws_credentials}"
  public_subnet_shift = 4
  private_subnet_shift = 2
  public_subnet_offset = 12

}

module "bs-dev" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "${var.aws_credentials}"
  eb_application_name = "${var.service_name}"
  vpc_id = "${module.aws_account.vpc_id}"
  ec2_subnet_ids = "${module.aws_account.private_subnets}"
  elb_subnet_ids = "${module.aws_account.private_subnets}"
  elb_loadbalancer_security_groups = "${module.aws_account.sg_id}"
  auto_scaling_lc_security_groups = "${module.aws_account.sg_id}"
  solution_stack_name = "64bit Amazon Linux 2016.09 v2.3.0 running Docker 1.11.2"
  auto_scaling_lc_keypair_name = "prod-tachanka"
  auto_scaling_lc_instance_type = "t2.micro"
  owner = "fuel-devportal@amazon.com"
  service = "commerce/tachanka"
  env = "prod"
  associate_public_address = "false"
  cname_prefix = "commerce-tachanka-prod"
}
