package usersservice

import (
	"code.justin.tv/common/twitchhttp"
	"golang.org/x/net/context"
)

// Property is a data field on a user.
type Property string

const (
	IsStaff               = "admin"
	IsAdmin               = "subadmin"
	IsGlobalMod           = "global_mod"
	DeletedOn             = "deleted_on"
	DMCAViolation         = "dmca_violation"
	TOSViolation          = "terms_of_service_violation"
	EmailProperty         = "email"
	ProfileImageProperty  = "profile_image"
	EmailVerifiedProperty = "email_verified"
)

// Client is an interface that exposes methods to fetch data from the users service.
type Client interface {
	BatchGetPropertiesFromID(ctx context.Context, ids []string, properties []Property, reqOpts *twitchhttp.ReqOpts) (*UsersResponse, error)
}

// UsersResponse is the response from /users.
type UsersResponse struct {
	Results []User `json:"results"`
}

// User is a model storing a user's data.
type User struct {
	ID     int           `json:"id"`
	Login  string        `json:"login"`
	Email  string        `json:"email"`
	Images ProfileImages `json:"profile_image"`

	IsStaff       *bool   `json:"admin"`
	IsAdmin       *bool   `json:"subadmin"`
	IsGlobalMod   *bool   `json:"global_mod"`
	DeletedOn     *string `json:"deleted_on"`
	DMCAViolation *bool   `json:"dmca_violation"`
	TOSViolation  *bool   `json:"terms_of_service_violation"`
	EmailVerified *bool   `json:"email_verified"`
}

// ProfileImages is a model storing a user's various image URLs
type ProfileImages struct {
	Tiny       ProfileImage `json:"28x28"`
	Small      ProfileImage `json:"50x50"`
	Medium     ProfileImage `json:"70x70"`
	Large      ProfileImage `json:"150x150"`
	ExtraLarge ProfileImage `json:"300x300"`
	Huge       ProfileImage `json:"600x600"`
}

// ProfileImage is a model storing a single profile image
type ProfileImage struct {
	Width  int    `json:"width"`
	Height int    `json:"height"`
	URL    string `json:"url"`
}
