package usersservice

import "github.com/stretchr/testify/mock"

import "code.justin.tv/common/twitchhttp"
import "golang.org/x/net/context"

type MockClient struct {
	mock.Mock
}

// BatchGetPropertiesFromID provides a mock function with given fields: ctx, ids, properties, reqOpts
func (_m *MockClient) BatchGetPropertiesFromID(ctx context.Context, ids []string, properties []Property, reqOpts *twitchhttp.ReqOpts) (*UsersResponse, error) {
	ret := _m.Called(ctx, ids, properties, reqOpts)

	var r0 *UsersResponse
	if rf, ok := ret.Get(0).(func(context.Context, []string, []Property, *twitchhttp.ReqOpts) *UsersResponse); ok {
		r0 = rf(ctx, ids, properties, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*UsersResponse)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, []string, []Property, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, ids, properties, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}
