package backend

import (
	"log"

	"github.com/cactus/go-statsd-client/statsd"
)

type Statter interface {
	IncCounter(path string)
}

type statterImpl struct {
	stats statsd.Statter
}

func NewStatter(stats statsd.Statter) Statter {
	return &statterImpl{
		stats: stats,
	}
}

func (s *statterImpl) IncCounter(path string) {
	err := s.stats.Inc(path, 1, 1.0)
	if err != nil {
		log.Printf("error sending %s counter", path)
	}
}
