package backend

import (
	"errors"
	"strconv"

	"code.justin.tv/chat/golibs/clients/usersservice"
	"golang.org/x/net/context"
)

type UserReader interface {
	GetUserByID(ctx context.Context, id int) (*usersservice.User, error)
}

type userReaderImpl struct {
	usersServiceClient usersservice.Client
}

func NewUserReader(usersServiceClient usersservice.Client) UserReader {
	return &userReaderImpl{
		usersServiceClient: usersServiceClient,
	}
}

func (u *userReaderImpl) GetUserByID(ctx context.Context, id int) (*usersservice.User, error) {
	ids := make([]string, 0, 1)
	ids = append(ids, strconv.Itoa(id))
	properties := make([]usersservice.Property, 0, 2)
	properties = append(properties, "login")
	properties = append(properties, "terms_of_service_violation")
	userResp, err := u.usersServiceClient.BatchGetPropertiesFromID(ctx, ids, properties, nil)
	if err != nil {
		return nil, err
	}

	if len(userResp.Results) == 0 {
		return nil, errors.New("no results returned")
	}

	user := userResp.Results[0]

	return &user, nil
}
