resource "aws_iam_role" "app" {
  name = "${var.iam_role_name}"
  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "ec2.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

resource "aws_iam_role_policy" "app" {
  name = "${var.iam_role_name}"
  role = "${aws_iam_role.app.id}"
  depends_on = ["aws_iam_role.app"]
  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": ["kinesis:DescribeStream", "kinesis:Get*"],
      "Effect": "Allow",
      "Resource": "${var.iam_kinesis_arn}"
    },
    {
      "Action": "dynamodb:*",
      "Effect": "Allow",
      "Resource": "${var.iam_dynamodb_arn}"
    }
  ]
}
EOF
}

resource "aws_iam_instance_profile" "app" {
  name = "${var.iam_role_name}"
  roles = ["${aws_iam_role.app.name}"]
}
