# Primary application ASG

resource "template_file" "app_user_data" {
  template = "${file("${path.module}/asg_puppetizer.template")}"
  vars {
    hostname_prefix = "${var.hostname}-aws"
    hostname_suffix = "${lookup(var.domain, var.environment)}"
    cluster = "${var.cluster}"
    environment = "${var.environment}"
  }

  lifecycle {
    create_before_destroy = true
  }
}

resource "aws_launch_configuration" "app_conf" {
  name_prefix = "${var.name}-app"
  image_id = "${var.ami}"
  instance_type = "${var.instance_type}"
  security_groups = ["${terraform_remote_state.twitch_target_aws_account.output.twitch_subnets_sg}"]
  user_data = "${template_file.app_user_data.rendered}"
  iam_instance_profile = "${aws_iam_instance_profile.app.id}"

  root_block_device {
    volume_size = "${var.root_volume_size}"
  }

  lifecycle {
    create_before_destroy = true
  }
}

resource "aws_autoscaling_group" "app_asg" {
  name = "${var.name}_${var.environment}_asg"
  vpc_zone_identifier = ["${terraform_remote_state.twitch_target_aws_account.output.service_a}",
                          "${terraform_remote_state.twitch_target_aws_account.output.service_b}",
                          "${terraform_remote_state.twitch_target_aws_account.output.service_c}"]
  max_size = "${var.max_size}"
  min_size = "${var.min_size}"
  health_check_grace_period = 600
  health_check_type = "EC2"
  launch_configuration = "${aws_launch_configuration.app_conf.name}"

  tag {
    key = "Name"
    value = "${var.name}"
    propagate_at_launch = true
  }
  tag {
    key = "Owner"
    value = "${var.owner}"
    propagate_at_launch = true
  }
  tag {
    key = "Project"
    value = "${var.project}"
    propagate_at_launch = true
  }
}

module "asg_dns" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/asg-r53-lambda.git//modules/notifications"
  topic_name = "${var.name}_${var.environment}_topic"
  asg_name = "${aws_autoscaling_group.app_asg.name}"
  lambda_arn = "${terraform_remote_state.production_asg_lambda.output.asg_lambda_arn}"
}
