resource "terraform_remote_state" "twitch_target_aws_account" {
  backend = "s3"
  config {
    bucket = "${lookup(var.target_aws_account, var.environment)}"
    region = "us-west-2"
    key = "tfstate/web/terraform/accounts/${lookup(var.target_aws_account, var.environment)}"
  }
}

resource "terraform_remote_state" "production_asg_lambda" {
  backend = "s3"
  config {
    bucket = "${lookup(var.target_aws_account, var.environment)}"
    region = "us-west-2"
    key = "tfstate/web/asg-r53-lambda/services/lambda/${lookup(var.target_aws_account, var.environment)}"
  }
}
