resource "aws_dynamodb_table" "checkpoints" {
  name = "nils-tos-o-bot"
  read_capacity = 1
  write_capacity = 100
  hash_key = "ShardId"
  range_key = "Environment"
  attribute {
    name = "ShardId"
    type = "S"
  }
  attribute {
    name = "Environment"
    type = "S"
  }
}

module "tos-o-bot" {
  source = "../modules/tos-o-bot"
  name = "tos-o-bot"
  hostname = "tos-o-bot"
  cluster = "tos-o-bot"
  owner = "ncaspar@twitch.tv"
  project = "ncaspar/tos-o-bot"
  ami = "ami-dd11f3bd"
  instance_type = "t2.medium"
  max_size = 1
  min_size = 1
  environment = "production"
  root_volume_size = "256"
  iam_role_name = "nils-tos-o-bot"
  iam_kinesis_arn = "arn:aws:kinesis:us-west-2:641044725657:stream/user-mutations"
  iam_dynamodb_arn = "${aws_dynamodb_table.checkpoints.arn}"
}

# ARN
output "arn-sqs-example-queue" {
 value = "${aws_dynamodb_table.checkpoints.arn}"
}
