import boto3

TABLE = "QueryFeatures"
ID = "ofs_id"

table = boto3.resource("dynamodb").Table(TABLE)
scan = None

with table.batch_writer() as batch:
    count = 0
    while scan is None or "LastEvaluatedKey" in scan:
        if scan is not None and "LastEvaluatedKey" in scan:
            scan = table.scan(
                ProjectionExpression=ID,
                ExclusiveStartKey=scan["LastEvaluatedKey"],
            )
        else:
            scan = table.scan(ProjectionExpression=ID)

        for item in scan["Items"]:
            if count % 5000 == 0:
                print(count)
            batch.delete_item(Key={ID: item[ID]})
            count = count + 1

# table = boto3.resource('dynamodb').Table("FICMultipleEntitiesVerificationFeaturesTable")
# scan = None
#
# with table.batch_writer() as batch:
#     count = 0
#     while scan is None or 'LastEvaluatedKey' in scan:
#         if scan is not None and 'LastEvaluatedKey' in scan:
#             scan = table.scan(
#                 ProjectionExpression=ID,
#                 ExclusiveStartKey=scan['LastEvaluatedKey'],
#             )
#         else:
#             scan = table.scan(ProjectionExpression=ID)
#
#         for item in scan['Items']:
#             if count % 5000 == 0:
#                 print(count)
#             batch.delete_item(Key={ID: item[ID]})
#             count = count + 1
#
#
# table = boto3.resource('dynamodb').Table("fic_load_test_3")
# scan = None
#
# with table.batch_writer() as batch:
#     count = 0
#     while scan is None or 'LastEvaluatedKey' in scan:
#         if scan is not None and 'LastEvaluatedKey' in scan:
#             scan = table.scan(
#                 ProjectionExpression=ID,
#                 ExclusiveStartKey=scan['LastEvaluatedKey'],
#             )
#         else:
#             scan = table.scan(ProjectionExpression=ID)
#
#         for item in scan['Items']:
#             if count % 5000 == 0:
#                 print(count)
#             batch.delete_item(Key={ID: item[ID]})
#             count = count + 1
#
