from decimal import Decimal

from octarine.clients.TwitchFeatureIngestionClient.feature_schema_pb2 import ValueType


def float_to_decimal(v):
    if isinstance(v, float):
        return Decimal(str(v))
    if isinstance(v, list) and v and isinstance(v[0], float):
        v = [Decimal(str(x)) for x in v]
        return v
    return v


def check_entity_ordering(metadata, entity_types):
    feature_metadata = metadata["feature_metadata"]
    entities = [str(x) for x in feature_metadata.entity]
    entity_order = "#".join(entities)
    return entity_types == entity_order


def check_feature_type(metadata, feature_val):
    feature_metadata = metadata["feature_metadata"]
    feature_shape = feature_metadata.value_type.shape
    feature_type = feature_metadata.value_type.type

    if (
        feature_shape == ValueType.DATA_SHAPE_UNSPECIFIED
        or feature_type == ValueType.DATA_TYPE_UNSPECIFIED
    ):
        return False

    if feature_shape == ValueType.DATA_SHAPE_BLOB:
        return True

    if feature_shape == ValueType.DATA_SHAPE_SCALAR:
        if feature_type == ValueType.DATA_TYPE_STRING and isinstance(feature_val, str):
            return True
        if feature_type == ValueType.DATA_TYPE_INTEGER and isinstance(feature_val, int):
            return True
        if feature_type == ValueType.DATA_TYPE_FLOAT and isinstance(feature_val, float):
            return True

    if isinstance(feature_val, list) and (
        feature_shape == ValueType.DATA_SHAPE_VECTOR
        or feature_shape == ValueType.DATA_SHAPE_LIST
    ):
        if feature_type == ValueType.DATA_TYPE_STRING and all(
            isinstance(val, str) for val in feature_val
        ):
            return True
        if feature_type == ValueType.DATA_TYPE_INTEGER and all(
            isinstance(val, int) for val in feature_val
        ):
            return True
        if feature_type == ValueType.DATA_TYPE_FLOAT and all(
            isinstance(val, float) for val in feature_val
        ):
            return True

    return False
