import os
import subprocess

from setuptools import find_packages, setup

# Fetch version from git tags, and write to version.py.
# Also, when git is not available (PyPi package), use stored version.py.
version_py = os.path.join(os.path.dirname(__file__), "version.py")

try:
    version_git = (
        subprocess.check_output(["git", "describe", "--tags"]).rstrip().decode("utf-8")
    )
except:
    with open(version_py, "r") as fh:
        version_git = open(version_py).read().strip().split("=")[-1].replace('"', "")

version_msg = "# Do not edit this file, pipeline versioning is governed by git tags"
with open(version_py, "w") as fh:
    fh.write(version_msg + os.linesep + '__version__="' + version_git + '"')

setup(
    name="TwitchFeatureIngestionClient",
    version="{ver}".format(ver=version_git),
    url="https://git.xarth.tv/octarine/TwitchFeatureIngestionClient",
    author="goutanai",
    author_email="goutanai@twitch.tv",
    license="Proprietary",
    classifiers=[
        "Intended Audience :: Developers",
        "License :: Other/Proprietary License",
        "Programming Language :: Python :: 3.8",
    ],
    install_requires=["protobuf <= 3.13", "boto3>=1.14.24",],
    python_requires=">=3.5",
    packages=find_packages(
        exclude=["tests", "scripts", "load-testing"],
    ),
    tests_require=[
        "pytest",
        "moto==1.3.14",
    ],
)
