# TwitchVXModelRegistryTwirpClient

A python client to make API calls to Model Registry service.

# Installation

See documentation on how to use the [internal pypi repository](https://git.xarth.tv/dta/docs/blob/master/artifactory/using-artifactory.md#pypi-repository) hosted in artifactory.
Steps: 
- update the pip.conf index-url to include the internal repository
- including the package in requirements.txt as any other pip package

# Usage

```python
from octarine.clients.TwitchVXModelRegistryTwirp import TwitchVXModelRegistryLambdaClient, GetModelRequest, TwirpException
import boto3

mr_client = TwitchVXModelRegistryLambdaClient('lambda-function-arn-here', boto3.client('lambda', region_name='us-west-2'))
req = GetModelRequest()
req.model_family = 'INTEGRATION_TEST_1599860906'
req.instance_id = '2020-09-11T14:48:27.941148-07:00'
try:
    resp = mr_client.get_model(req)
except TwirpException as e:
    # handle expection here
    raise e
metadata = resp.metadata
```

# Deploy a new version

1. Go into `submodule` directory, and run `git pull` to get the latest Schema proto files
2. Run `make generate` to generate new python code form the schema file. The protoc plugin can be found [here](https://git.xarth.tv/liverecs/fulton-lambda-python-twirp-generator)
3. Merge the approved branch to master and use `make tag` to draft a new release
4. Build the Tag in Jenkins:
- Navigate to the tag builds of [model registry client](https://jenkins-og.xarth.tv/job/octarine-twitchvxmodelregistry/view/tags/)
- Click on the icon to build the new tag under the `Build On` section
- The build will automatically push the new version to Artifactory. The version name will match the tag.
