# TwitchVXModelRegistryUtils

A python packagage that deploys model to SageMaker and call Model Registry to update the model status

# Installation

See documentation on how to use the [internal pypi repository](https://git.xarth.tv/dta/docs/blob/master/artifactory/using-artifactory.md#pypi-repository) hosted in artifactory.
Steps: 
- update the pip.conf index-url to include the internal repository
- including the package in requirements.txt as any other pip package

# Usage

```python
import boto3
from octarine.clients.TwitchVXModelRegistryTwirp import MODEL_PRODUCER_VX_CAMI, TwitchVXModelRegistryLambdaClient
from octarine.utils.TwitchVXModelRegistryUtils import deploy_model, Config

deploy_config = Config(
    endpoint_name='test-endpoint,
    execution_role_arn='arn:aws:iam::xxxxx:role/SageMaker-Execution-role',
    model_s3_location='s3://some-bucket/xgb-churn-prediction-model.tar.gz',
    container_url="246618743249.dkr.ecr.us-west-2.amazonaws.com/sagemaker-xgboost:0.90-1-cpu-py3",
    variant_name="Variant1",
    initial_instance_count=1,
    instance_type="ml.m5.xlarge",
)

model_registry_client = TwitchVXModelRegistryLambdaClient(
    lambda_endpoint=MODEL_REGISTRY_BETA_ENDPOINT,
    boto_lambda_client=boto3.client("lambda", region_name="us-west-2"),
)

deploy_model(
    model_family='a-model-family',
    instance_id='an-instance-id',
    model_producer_identity=MODEL_PRODUCER_VX_CAMI,
    deploy_config=deploy_config,
    model_registry_client=model_registry_client,
    environment='staging'  
)

```

# Input Parameters
| Name                     | Type                     | Description                                                                       | Sample Value                                                                                                                                                          |
| ------------------------ | ------------------------ | --------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| endpoint\_name           | string                   | The name of the endpoint                                                          | DEMO-xgb-pred                                                                                                                                                         |
| execution\_role\_arn     | string                   | The role SageMaker will assume when creating endpoint and performing inference    | arn:aws:iam::678783758386:role/service-role/AmazonSageMaker-ExecutionRole-20200723T125742                                                                             |
| model\_name     | string                   | The name of the model. This will be used for `CreateModel` API call on sagemaker. If not passed in, it will be a concatenation of model family and instance id.    | model-multiwindow                                                                             |
| model\_s3\_location      | string                   | The s3 location of the model artifact                                             | s3://shuazh-sagemaker/sagemaker/DEMO-VariantTargeting/xgb-churn-prediction-model.tar.gz                                                                               |
| container\_url           | string                   | The inference image url                                                           | [246618743249.dkr.ecr.us-west-2.amazonaws.com/sagemaker-xgboost:0.90-1-cpu-py3](http://246618743249.dkr.ecr.us-west-2.amazonaws.com/sagemaker-xgboost:0.90-1-cpu-py3) |
| env\_variables           | dict\[string\]string     | The environment variables that will be set on the container                       | `{“env_var1”: “some value”}`                                                                                                                                 |
| variant\_name            | string                   | The name of the variant for this model                                            | Variant1                                                                                                                                                              |
| initial\_instance\_count | int                      | The number of instances that host the model                                       | 1                                                                                                                                                                     |
| retain\_all\_variant\_properties           | bool                   | Whether desired instance counts and variant weights are retained during endpoint update. This only applies to the same variant name. By default, this is set to `True`                                     | True                                                                                                                                                          |
| instance\_type           | string                   | The type of the instance that hosts the model                                     | ml.m5.xlarge                                                                                                                                                          |
| vpc\_config              | dict\[string\]\[\]string | The vpc config of the model. It will be passed to CreateModel API call            | [https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html)         |
| tags                     | dict\[string\]string     | The tags will be passed CreateModel, CreatEndpointConfig, CreateEndpoint API call | `{“key”: “value”}`                                                                                                                                              |

# Deploy a new version


1. Merge the approved branch to master and use `make tag` to draft a new release
2. Build the Tag in Jenkins:
- Navigate to the tag builds of [model registry utils](https://jenkins-og.xarth.tv/job/octarine-twitchvxmodelregistryutils/view/tags/)
- Click on the icon to build the new tag under the `Build On` section
- The build will automatically push the new version to Artifactory. The version name will match the tag.
