from setuptools import find_namespace_packages, setup

scm_version_options = {"write_to": "version.py"}


setup(
    name="octarine.utils.TwitchVXModelRegistryUtils",
    url="https://git.xarth.tv/octarine/TwitchVXModelRegistryUtils",
    author="shuazh",
    author_email="shuazh@twitch.tv",
    license="Proprietary",
    classifiers=[
        "Intended Audience :: Developers",
        "License :: Other/Proprietary License",
        "Programming Language :: Python :: 3.8",
    ],
    install_requires=[
        "octarine.clients.TwitchVXModelRegistryTwirp >= 1.4",
        "sagemaker ~= 2.23",
        "attrs",
    ],
    python_requires=">=3.5",
    use_scm_version=scm_version_options,
    setup_requires=["setuptools_scm"],
    packages=find_namespace_packages(
        include=["octarine.*", "octarine.utils.*"],
        exclude=["tests"],
    ),
    include_package_data=True,
    extras_require={},
    tests_require=[
        "pytest",
    ],
)
