# Documentation Template

This is a template repository for creating pretty documentation sites using [Hugo](https://gohugo.io/), hosted on Github Pages and deployed by Jenkins.

![Screenshot](screenshot.png)

## Quickstart

1. Click on <a href="https://git.xarth.tv/points/docs-template/generate"><img src="use_this_template.png" height="24em" vertical-align="center"></a>
to generate your new repository based on this template. Choose "Include all branches" here to include the gh-pages one.
1. Replace `points/docs-template` in the [Makefile](Makefile) and [config.toml](config.toml) with your organization/repository.
(There are two occurrences of this string in each file, on lines 24 and 31 in the Makefile and lines 1 and 15 of the config.toml, respectively.) Push this change to master.
1. Go to Settings -> Collaborators & Teams and add [devtools](https://git.xarth.tv/devtools) as a collaborator with write permissions.
1. Go to Settings -> Hooks -> Add Webhook and create a simple Jenkins webhook. Set "Payload URL" to `https://jenkins-og.xarth.tv/github-webhook/` and set "Content type" to `application/json`. The other settings can remain at default. Click "Add Webhook".
1. Your page should now be regenerating automatically every time you push master -- you can view the Jenkins logs at https://jenkins-og.xarth.tv/. Your site should be available at https://git.xarth.tv/pages/organization/repository.

## Running Locally

#### Install Hugo

`brew install hugo`

#### Run server

`hugo serve`

This will start a server on localhost:1313 that automatically updates when local files change.

## Adding Content

You can add or update pages by creating `.md` files and directories in the `content/` directory.

Nested directories will become hierarchical folders.

`_index.md` is a special filename that will display at the top level of its directory.

Image/static assets placed in the `static/` directory will be accessible as top level assets, for example for image embedding.

The [Hugo docs](https://gohugo.io/documentation/) have way more information than I could hope to convey here.

Happy documenting!
