---
title: A. Basics
---

## Flat Service Layout

- Prefer keeping package structure as **flat** as possible.
While it may seem like a good idea to add as much decoupling as possible through extensive use of interfaces,
in practice this ends up leading to a lot of nasty boilerplate needed to make small changes.
- Keep [YAGNI](https://en.wikipedia.org/wiki/You_aren%27t_gonna_need_it) in mind when laying out code.
We have often been burned **more** by premature optimization and over-abstraction.

### Examples of Anti-Patterns

- The Backender interface, where each Backender method is essentially just wrapping a call to the underlying client interface
- The server/logic/data pattern – prefer just putting the "logic" into the "server" package unless you have very specific reasons not to

## "Ideal" Package Layout

```text
cmd/
    main.go
internal/
    server/
    clients/
        db/
        auth/
        pubsub/
```
