---
title: C. Circuits
---

## What are Circuits?

Circuits are mechanisms to cut off traffic to dependencies when certain criteria (typically repeated failures)
are reached. They are an essential tool for limiting the blast radius and duration of outages.
By automatically opening after receiving a certain (configurable) percentage of failures in a time frame,
we can stop hammering a dead dependency long enough to give it time to recover on its own.

> Note: circuits start off "closed" but "open" when there is an issue.
> The naming comes from electrical circuits, where "closing" the circuit is what allows the current to flow.

Further benefits of circuits, taken from the Cep21/Circuit readme:
- A downstream service failed and all requests hang forever. Without a circuit, your service would also hang forever. Because you have a circuit, you detect this failure quickly and can return errors quickly while waiting for the downstream service to recover.
- Circuits make great monitoring and metrics boundaries, creating common metric names for the common downstream failure types. This package goes further to formalize this in a SLO tracking pattern.
- Circuits create a common place for downstream failure fallback logic.
- Downstream services sometimes fail entirely when overloaded. While in a degraded state, circuits allow you to push downstream services to the edge between absolute failure and mostly working.
- Open/Close state of a circuit is a clear early warning sign of downstream failures.
- Circuits allow you to protect your dependencies from abnormal rushes of traffic.

## Cep21/Circuit vs Afex/Hystrix-Go

Both of these libraries were created by Twitch (or former Twitch) engineers to tackle the problem of adding
circuit-breakers to Go services.

We use [Cep21/Circuit](https://github.com/cep21/circuit) to create circuits wrapping all of our clients.
We prefer Cep21 to other similar tools like [Hystrix-Go](https://github.com/afex/hystrix-go) because
it works with [Twitchtv/Circuitgen](https://github.com/twitchtv/circuitgen) to automatically create
circuits for all of our dependencies. It also has several smaller benefits over hystrix-go, such as not requiring the
creation of new goroutines for each circuit execution, and enhanced metrics for circuits.

