---
title: PDMS
weight: 1
---
## What is PDMS?

Personal Data Management System (PDMS) issues and tracks deletion and access requests for personal data related to user accounts. If your service stores protected user data, you must onboard to PDMS. Check out the [PDMS source code here](https://code.amazon.com/packages/PDMSLambda).

## Why PDMS?

To ensure that we are compliant with all parties that interact with Twitch, we need to ensure that any private user data we store is handled properly, in accordance with all our legal obligations (e.g. General Data Protection Regulation (GDPR), our Terms of Service (TOS), our Affiliate Agreement, etc.).

## Do I need PDMS?

If your service stores any private, personal, or identifiable user data, you'll need to [onboard with PDMS]({{< ref pdms_onboarding >}}). [Check out the Privacy wiki page](https://wiki.xarth.tv/display/TTV/Privacy) for an in-depth explanation of what protected data is.

If you are still unsure if you need to onboard, reach out to @hoang for further guidance.

### Features
* **Data deletion**: Tracks which users have initiated deletion requests and asks your service to delete requested data.
* **Data access**: Allows a Twitch user to access their data from your service.
* **Data auditing**: Tracks all services that have deleted data or have promised to delete data by a certain date.