---
title: API Reference
weight: 4
---
On this page, you'll find general APIs for polling and reporting delete and access attempts. For the actual data structures returned, check the Twirp schema files available in the [PDMSLambdaSchema repo](https://code.amazon.com/packages/PDMSLambdaSchema/trees/mainline/--/model/code.justin.tv/amzn/PDMSLambdaTwirp).

## Deletion 
Twirp Method|Description|Return Data
------------|-----------|-----------
`ReportDeletion(serviceId,`<br />`userId, timestamp)`| Reports deletion. `timestamp` is optional. If you leave `timestamp` empty, it will default to the current time.| n/a
`PromiseDeletion(serviceId,`<br />`userId, timestamp, autoresolve)`| Promises a deletion. This means the calling service acknowledges that it's received the delete signal and is promising that deletion will occur by a certain time. `timestamp` is not optional. Set `autoresolve` to `false` if you want to be required to report deletion again. Set to `true` if you want this user to be automatically marked as deleted on the date set.| n/a
`GetDeletedUserData(userId)`| Gets certain archived data for a deleted `userId`. This is useful if certain information is needed to complete the deletion. This will return an error if the deletion request of this user ocurred more than 90 days ago.| `userId`, `Login`, `Email`, `Created` (time user was deleted, or time the deletion was created), `AssociatedExtensionClientIds` (list of extension client IDs associated with this user).
`GetOutStandingDeletionRequestsByService(serviceId,`<br />`PageToken, PageSize)`| Returns a list of outstanding (defined as deletion requests the calling service is responsible for that have not been responded to) deletion requests for a service in descending order by time. | `List<DeletionRequests>`, `NextPageToken`: The page token to pass back to PDMS to get the next set of deletions. This will be empty if there are no more deletion requests to fetch.
`GetPromises(serviceId,`<br />`DueBefore, DueAfter)`| Returns a list of deletion requests promised with due dates between `DueAfter` and `DueBefore`. This does not return any promises which have been marked as deleted or any with `autoresolve` set to `true`. Use this to keep tabs on what you've promised to delete.| `List<DeletionRequests>`, `DueCursor`: The last due time of the deletion request returned in this set. This is empty if there are no more entries to fetch for this query.
`GetUserDeletionStatus(userId)`| Gets the status of the users requested deletion.| `Map<serviceId, DeletionStatus>`

## Access
Twirp Method|Description|Return Data
------------|-----------|-----------
`ReportAccessRequest(serviceId,`<br />`userId, hasData)`| Reporting function for Access Requests. `hasData` should be `true` if you have data to report, `false` otherwise. Setting `hasData` to `false` will immediately mark the request as fulfilled. | `UploadUrl`: signed S3 url to upload to. This is only returned if `hasData` is set to `true`.
`GetOutStandingAccessRequestsByService(serviceId,`<br />`CreatedAfter, CreatedBefore)`| Returns a list of outstanding access requests (defined as access requests not yet responded to).| `List<AccessRequests>`, `CreationTimeCursor`: The creation time of the access request returned. This will be empty if there are no more deletion requests to fetch.
`GetUserAccessStatus(userId)`| Gets the status of the user's access request.| `Map<serviceId, AccessStatus>`

## Testing
Twirp Method|Description|Return Data
------------|-----------|-----------
`SetTestDeletion(userId,`<br />`serviceId, CreationTime)` | Only available on the staging API. Sets a test deletion entry for the `serviceId` / `userId` pair provided. Use for integration tests.| n/a
