---
title: PDMS Onboarding
weight: 2
---

To onboard with PDMS:

1. [Find your service in Catalog](https://catalog.xarth.tv/services) and answer all questions in the **Privacy** section.
1. [Open an PRIVENG ticket](https://jira.twitch.com/projects/PRIVENG/summary ) that includes the service's name, a link to the service's Catalog entry, and whether the onboarding is for access requests, delete requests, or both. [Here's an example of a completed ticket](https://jira.xarth.tv/browse/PRIVENG-115).
1. [Create and attach IAM policies](#creating-and-attaching-iam-policies) while your ticket is being reviewed:
    1. From the AWS console, navigate to **Services** > **IAM** > **Policies**, then click **Create policy**.
    1. From the **JSON** tab, copy-paste the appropriate policy:
    
        **Staging (Beta)**
        ```json
        {
            "Version": "2012-10-17",
            "Statement": [
                {
                    "Sid": "",
                    "Effect": "Allow",
                    "Action": "sts:AssumeRole",
                    "Resource": [
                        "arn:aws:iam::895799599216:role/PDMSLambda-CallerRole-18451FI19HSXT"
                    ]
                }
            ]
        }
        ```
        **Production**
        ```json

        {
            "Version": "2012-10-17",
            "Statement": [
                {
                    "Sid": "",
                    "Effect": "Allow",
                    "Action": "sts:AssumeRole",
                    "Resource": [
                        "arn:aws:iam::125704643346:role/PDMSLambda-CallerRole-13IIND444YKVR"
                    ]
                }
            ]
        }
        ```
    1. Click **Review**.
    1. Provide a name and description for the policy, then click **Create policy**.
1. Once you've created the policy, attach it to your application role:
    1. From **Services** > **IAM** > **Policies**, search for the policy you created above and set its radial button.
    1. Click **Policy actions**, then select **Attach**.
    1. Search for your application's role and set its checkbox.
    1. Click **Attach policy**.
1. Once you've attached the policy and your service has been allowlisted, [onboard your data to receive delete and access requests]({{< ref "delete_and_access" >}}). You can check that your service is allowlisted by [looking at the PDMS source code](https://code.amazon.com/packages/PDMSLambda/blobs/59c94b61cdd3989be1f35eeba1dd0c55e98beb87/--/src/clients/servicecatalog/allowlistcatalog.go#L17,L79).


Arns to call PDMS:
1. Beta
    1. lambda: arn:aws:lambda:us-west-2:895799599216:function:PDMSLambda-LambdaFunction-IT8I1PE1YR81
    1. role: arn:aws:iam::125704643346:role/PDMSLambda-CallerRole-13IIND444YKVR
1. Prod
    1. lambda: arn:aws:lambda:us-west-2:125704643346:function:PDMSLambda-LambdaFunction-11LXHJVSNJJPY
    1. role: arn:aws:iam::125704643346:role/PDMSLambda-CallerRole-13IIND444YKVR
