package s3io

import (
	"io"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/s3"
	"github.com/aws/aws-sdk-go/service/s3/s3manager"
)

// S3Reader downloads serialized protobuf data from s3 and implements io.Reader.
type S3Reader struct {
	Bucket     string
	Key        string
	Data       []byte
	Downloader *s3manager.Downloader
}

// Read implements io.Reader interface and downloads data from an s3 signed url.
func (s S3Reader) Read(p []byte) (n int, err error) {
	buff := &aws.WriteAtBuffer{}
	result, err := s.Downloader.Download(
		buff,
		&s3.GetObjectInput{
			Bucket: aws.String(s.Bucket),
			Key:    aws.String(s.Key),
		},
	)
	if err != nil {
		return 0, err
	}
	s.Data = buff.Bytes()
	return int(result), nil
}

func newS3Reader(bucket, key string, downloader *s3manager.Downloader) io.Reader {
	Reader := S3Reader{
		Bucket:     bucket,
		Key:        key,
		Downloader: downloader,
	}

	return Reader
}
