package s3io

import (
	"bytes"
	"fmt"
	"io"
	"io/ioutil"
	"net/http"
	"time"
)

// S3Writer uploads serialized protobuf data to s3 and implements io.Writer.
type S3Writer struct {
	Target string
}

// Writer implements io.Writer interface and uploads to the target signed s3 url.
func (s S3Writer) Write(p []byte) (n int, err error) {
	req, err := http.NewRequest("PUT", s.Target, bytes.NewReader(p))
	if err != nil {
		fmt.Println("failed building request")
		return 0, err
	}

	httpClient := &http.Client{
		Timeout: time.Second * 60,
	}
	res, err := httpClient.Do(req)
	if err != nil {
		fmt.Println("failed making request")
		return 0, err
	}
	if res.StatusCode != http.StatusOK {
		body, err := ioutil.ReadAll(res.Body)
		if err != nil {
			return 0, err
		}
		fmt.Printf("write failed: %s", string(body))
		return 0, fmt.Errorf("bad http status: %s", res.Status)
	}
	return len(p), nil
}

func NewS3Writer(target string) io.Writer {
	writer := S3Writer{
		Target: target,
	}

	return writer
}
