# TwitchCon with CMS Demo

### Install the webhook cli
```sh
$ npm install -g wh grunt-cli
```

### Clone the repo where ever you would like and initialize the site
You will need an invite to the twitchcon cms and a user name and password to initialize the site. Contact [Alexis](mailto:agallisa@twitch.tv) for more info. You will also need the server address where we host the TwitchCon webhook service. Currently 10.192.67.43.

```sh
$ git clone git@git-aws.internal.justin.tv:product/twitchcon.git
$ cd twitchcon
$ wh init tw-demo -f webhook-twitch -s 10.192.67.43
```

### Install npm dev dependencies

```sh
$ npm install
```


### Serve the site, compile the css, create svg sprites etc

```sh
$ grunt
```

### Deploy the site
```sh
wh deploy -s 10.192.67.43
```


# Webhook?
[Webhook](http://www.webhook.com) is a CMS with a static site generator. The CMS is a one page web app written in Ember which stores all of its data in a firebase DB. Currently this DB is shared between production and local hosting. Saves in the CMS cause a satic build of all html files which are built with the template language SWIG.

### CMS Form Builder
Items in the CMS can be created as single items such as a standalone page (About Us, Contact Page,etc) or as a multiple item object (events, authors, blog entries, etc). Data for these items are created with a drag and drop form builder interface and data points created by this form is immediatelty available in templates.

![](http://cl.ly/image/2r0z0e3Y0y2f/formbuilder.png)


### SWIG Template Engine
[SWIG](http://paularmstrong.github.io/swig/) is template engine based on Django (python) which allows for quickly creating new pages and template variants through the use of blocks. It's awesome.

![](http://f.cl.ly/items/1L2W0n3d2a3U1i1y011A/swig.png)

# Auto Styleguide
TwitchCon's stylgeuide is auto created by the grunt task called style. When working on changes to the stylguide running this task will create a watcher will will parse the sass directory and build the styleguide based on kss documentation. [http://localhost:2002/styleguide/](http://localhost:2002/styleguide/)

```
$ grunt style
```
![](http://cl.ly/image/2r0J1a2l0Z3c/styleguide.png)

# Auto Svg Sprites
Documentation to come but basically this auto creates an svg sprite from a folder of resources which we can then use across the site with minimal html.

[http://localhost:2002/svg/](http://localhost:2002/svg/)

```
$ grunt svg
```

![](http://cl.ly/image/2M0P0z1t0L1q/svg.png)
