job {
  name 'product-twitchcon'
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'product/twitchcon', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }
  steps {
    shell 'test -d .output && rm -rf .output/ || true'
    shell 'mkdir .output/'
    shell 'cp -r * .output'
    saveDeployArtifact 'product/twitchcon', '.output'
  }
}

job {
  name 'product-twitchcon-deploy'
  using 'TEMPLATE-deploy'
  steps {
    shell 'courier deploy --repo product/twitchcon --dir /opt/twitch/twitchcon --skip-restart'
  }
}
