//Init the mobile nav function
var navToggle = function (e) {
  $('body').toggleClass('is-navbar-active');
  e.preventDefault();
}

// We commonly need to grab the url where we are or came from for our animation scenes
// By default this will return a string enter- + the url path without domain
var getEnterExitString = function(e) {
  var url = e + '-' + $(location).attr('pathname').replace(/\//g, '');
  return url;
}

// Shorthand for $( document ).ready()
$(function() {

  $('#main').attr('data-enter', getEnterExitString('enter'));

  if (!Modernizr.touch) {

    'use strict';
    var $body = $('html, body'),

      smoothState = $('#main').smoothState({

        prefetch: true,
        pageCacheSize: 8,
        blacklist: ".no-smoothstate, [target], [data-type='image'] a",
        scroll: false,

        // OnStart
        onStart: {
          duration: 600,
          render: function($container) {

            // Scroll page back up
            $body.animate({
              scrollTop: 0
            });

            // Create a data attribute called enter- which lets the scene know where it is
            // Get the string value from getEnterExitString
            $('#main')
              .removeClass('transition-start')
              .addClass('transition-end')
              .attr('data-enter', getEnterExitString('enter'));

            $('body').removeClass('is-navbar-active');
            // Kill modal if it was open from the schedule page
            $('.modal-backdrop').remove();

          }
        },

        // OnBefore
        onBefore: function($currentTarget, $content) {
          // Create a data attribute called exit- which lets the next scene know where it came from.
          // Get the string value from getEnterExitString
          $('#main').attr('data-exit', getEnterExitString('exit'));
        },

        // OnAfter
        onAfter: function($container, $content) {
          // Add the transition start class for transitions duh
          $('#main')
            .removeClass('transition-end')
            .addClass('transition-start');

          if (!Modernizr.touch) {
            $('.js-fluidbox, [data-type="image"] a').fluidbox();
          }

          $(".js-ticketfairy").pin({
            containerSelector: ".container",
            minWidth: 768,
            padding: {top: 70, bottom: 10},
          })

        }

      }).data('smoothState');

  } //If Not a touch device

  // KICK OFF BEFORE SMOOTHSTATE
  // Since smoothstate is not available on first load of a page we need to kick off
  // some of our most commong js functions. (this could be done better)
  // ------------------------------------------------------------------

  // Kick off the animation class on first load
  $('#main').addClass('transition-start');
  // Set up navToggle Function
  $(document).on('click', '.js-nav-toggle', navToggle);
  // Bind fluidbox to anchors with the class js-fluidbox
  if (!Modernizr.touch) {
    $('.js-fluidbox, [data-type="image"] a').fluidbox();
  }
  // Pin the ticketfairy module
  $(".js-ticketfairy").pin({
    containerSelector: ".container",
    minWidth: 768,
    padding: {top: 70, bottom: 10},
  })

});


// Window.load function mostly for preloading of css images on non touch devices
$(window).load(function() {

  $.preloadImages = function() {
    for (var i = 0; i < arguments.length; i++) {
      $('<img />').attr('src', '/static/images/' + arguments[i]);
    }
  }

  // These are a ton of images and preloading them might be overkill but we need them to be avaiable for the transitions before screens. We also only do this once window.load occurs.

  if (!Modernizr.touch) {
    $.preloadImages(
      'kubrick-schedule-base.jpg',
      'kubrick-schedule-stage.png',
      'kubrick-schedule-screen.png',
      'kubrick-schedule-trees4.png',
      'kubrick-schedule-kiosk2.png',
      'kubrick-schedule-trees2.png',
      'kubrick-schedule-trees3.png',
      'kubrick-schedule-kiosk1.png',
      'kubrick-schedule-trees1.png',
      'kubrick-schedule-exit.png',
      'kubrick-tickets-track-right.png',
      'kubrick-tickets-booth.png',
      'kubrick-tickets-sign.gif',
      'kubrick-tickets-track-left.png',
      'kubrick-tickets-coins.png',
      'kubrick-tickets-trees3.png',
      'kubrick-tickets-sword.png',
      'kubrick-tickets-chest.png',
      'kubrick-tickets-column1.png',
      'kubrick-tickets-blocks.png',
      'kubrick-tickets-trees1.png',
      'kubrick-tickets-cart-left.png',
      'kubrick-hotel-base.jpg',
      'kubrick-hotel-building.png',
      'kubrick-hotel-sign.png',
      'kubrick-hotel-loop.png',
      'kubrick-hotel-flag.png',
      'kubrick-hotel-spring.png',
      'kubrick-hotel-ladders.png',
      'kubrick-hotel-trees5.png',
      'kubrick-hotel-trees3.png',
      'kubrick-hotel-trees1.png',
      'kubrick-hotel-balloon.png',
      'kubrick-hotel-trees2.png',
      'kubrick-hotel-trees4.png'
    );

  }


});
