// Extends :contains to be case insensitive function from:
// http://www.robsawyer.me/blog/2013/07/10/lightweight-jquery-searchfilter-tutorial/
$.extend($.expr[':'], {
  'containsi': function(elem, i, match, array) {
    return (elem.textContent || elem.innerText || '').toLowerCase().indexOf(
      (match[3] || "").toLowerCase()) >= 0;
  }
});

// Set search parameters into an object so we can filter on any of the 3 items independently
var searchParameters = {
  text: '',
  category: '',
  location: ''
};

// Because each .schedule-block has one dt.schedule-time and many dd.js-search-item
// We need to check if all .js-search-item within a block are hidden
// If so hide the entire block along with dt.schedule-time so we don't end up with
// a ton of orphaned time blocks
var searchHideTimes = function() {
  $('#js-search-list .schedule-block').each(function(e) {
    if ($(this).find('.js-search-item.is-hidden').length == $(this).find(
      '.js-search-item').length) {
      $(this).addClass('is-hidden');
    }
    else {
      $(this).removeClass('is-hidden');
    }
  });
};

// Main Search Function
var searchFilter = function(s) {
  $('#js-search-list .js-search-item').each(function(i, delement) {
    var element = $(delement),
      text = element.text().toLowerCase(),
      hide = false;

    var searchHideNodes = function(parameter) {
      if (parameter && text.indexOf(parameter.toLowerCase()) < 0) {
        hide = true;
      }
    };
    searchHideNodes(searchParameters.text);
    searchHideNodes(searchParameters.category);
    searchHideNodes(searchParameters.location);

    element.toggleClass('is-hidden', hide);
  });
  searchHideTimes();
}

$(document).ready(function() {

  // ----------------
  // Search Input Box
  // ----------------
  $('#js-search-text').keyup(function() {
    // var from search input box and send to search filter function
    var searchTerm = $('#js-search-text').val();
    var searchSplit = searchTerm.replace(/ /g, "'):containsi('")
    searchParameters.text = searchSplit;
    searchFilter();
  });

  // -----------------------
  // Category DropDown Filter
  // -----------------------
  $('.js-search-category').change(function() {
    $('.js-search-category option:selected').each(function() {
      searchParameters.category = $(this).data('filter');
      searchFilter();
    });
  });


  // --------------------------------------
  // Initialize Modals on non touch devices
  // --------------------------------------
  if (!Modernizr.touch) {
    $('.js-modal-trigger').click(function(e) {
      e.preventDefault();
      // The next function is probably not the greatest, but it causes little dom find time. It's just next!
      $(this).next(".modal").modal('show');
    });
  };

});
