$(function() {
    // Global variables
    // set jquery lookups as vars to avoid constant lookups
    var grayskull = $("#js-grayskull");

    // Add sun phases to an array so we can dynamically add more frames at a later date
    // This hardcoded path to the asset domain should probably be a variable but eh its not that hard to change
    var sun = [
        '/static/images/sun-0.png',
        '/static/images/sun-1.png',
        '/static/images/sun-2.png',
        '/static/images/sun-3.png',
        '/static/images/sun-4.png',
        '/static/images/sun-5.png',
        '/static/images/sun-6.png',
        '/static/images/sun-7.png',
        '/static/images/sun-8.png',
        '/static/images/sun-9.png',
        '/static/images/sun-10.png',
        '/static/images/sun-11.png'
    ];

    // Build fancy mouse based sun shadow island if not on a touch device
    if (!Modernizr.touch) {

        // Create the pieces of the castle using the sun array length from above
        for (var i = 0; i < sun.length; i++) {
            grayskull.append('<div class="active pblock sun sun-' + i +
                '"></div>');
            $('.sun-' + i).css('background-image', 'url(' + sun[i] +
                ')');
        }

        // Calculate the mouse position using Jquery's pageX variable and
        // turn this into a percentage based on the amount of sun phases
        $(window).mousemove(function(event) {
            var windowSize = $(window).width();
            var windowPosition = Math.round(event.pageX /
                windowSize * 100);
            for (var i = 0; i < sun.length; i++) {
                var windowPercent = (i / sun.length) * 100;
                if (windowPosition < windowPercent) {
                    $('.sun-' + i).removeClass('active');
                } else {
                    $('.sun-' + i).addClass('active');
                }
            }
        });

    // In retrospect this first div should probably have been prebuilt into the html and then the later sun phases built by JS if not on a touch device but eh I really want a taco right now so lets just let it be.
    } else {

        grayskull.append('<div class="active pblock sun sun-0"></div>');
        $('.sun-0').css('background-image', 'url(' + sun[0] + ')');

    }


});
