# cgroups

#### Table of Contents

1. [Overview](#overview)
2. [Module Description - What the module does and why it is useful](#module-description)
3. [Setup - The basics of getting started with cgroups](#setup)
    * [Setup requirements](#setup-requirements)
4. [Usage - Configuration options and additional functionality](#usage)
5. [Reference - An under-the-hood peek at what the module is doing and how](#reference)
6. [Contents - List of all classes, params, defines, and facts](#contents)

## Overview

Provides installation and configuration of cgroups for a service.
Creates directory structure and rules processing.

When used with daemontools::supervise, will ensure everything is configured
properly in the run script.

## Module Description

Provides interface to setup cgroups for a service.

## Setup
Recommended to use with daemontools::supervise.  Set the daemontools::supervise parameter
enable_cgroups = true.  The default enabled cgroups are 'cpuacct' and 'memory'.  This config
is *not* additive, if you want to add additional cgroups, also add 'cpuacct' and 'memory' (if
you want them).

For usage outside of daemontools::supervise, create cgroups::service resource(s).  There is no
guarantee that cgroup directories will exist on reboot (cgroups do not persist across machine
restarts).  A script containing the rules hash will exist in /usr/local/bin/cgroups_rules_$name.sh.
It is encouraged to make sure this runs during your service start.

### Setup Requirements
Requires stdlib >= 4.5.0

## Usage
daemontools::supervise example.  This will result in:
create: /sys/fs/cgroups/cpuacct/system/cgroups_example
create: /sys/fs/cgroups/memory/system/cgroups_example
create: /sys/fs/cgroups/blkio/system/cgroups_example
create: /usr/local/bin/cgroups_rules_cgroups_example.sh
edits: /etc/service/cgroups_example/run
  - adds: mkdir -p for each /sys/fs... directory
  - adds: calls /usr/local/bin/cgroups_rules_cgroups_example.sh
  - adds: echo $$ to cgroup.procs file for each cgroup in $cgroups

daemontools::supervise{ 'cgroups_example':
  wd             => '/tmp',
  daemon         => 'sleep 30',
  enable_cgroups => true,
  cgroups        => ['cpuacct','memory','blkio']
  cgroups_rules  => {
    'memory' => {
      'memory.swappiness' => '1',
    },
    'blkio'  => {
      'blkio.weight' => '100',
    }
  },
}

Without daemontools::supervise example:
create: /sys/fs/cgroups/cpuacct/system/cgroups_example
create: /sys/fs/cgroups/memory/system/cgroups_example
create: /sys/fs/cgroups/blkio/system/cgroups_example
create: /usr/local/bin/cgroups_rules_cgroups_example.sh

cgroups::service{ 'cgroups_example':
  cgroups        => ['cpuacct','memory','blkio']
  cgroups_rules  => {
    'memory' => {
      'memory.swappiness' => '1',
    },
    'blkio'  => {
      'blkio.weight' => '100',
    }
}

## Contents

### Class cgroups parameters
* basedir
* namespace
* package
* service

### Classes
* cgroups
* cgroups::params

### Definitions
* cgroups::service
* cgroups::namespace

### Facts
* available_cgroups
