# List cgroups found in cpath
# cgroups are top level dirs in cpath
def getcgroups(cpath)
  cgroups = []
  if File.directory?(cpath)
    cgroups = Dir.entries(cpath).reject!{ |f| f =~ /^\.{1,2}$/ }
  end

  return cgroups
end

if Facter.value(:kernel) == 'Linux'
  cgroup_basedir = '/sys/fs/cgroup'
  available_cgroups = []

  Facter.add('available_cgroups') do
    available_cgroups = getcgroups(cgroup_basedir)
    setcode { available_cgroups.join(',') }
  end
end
