# == Define: courier::dirs
#
# === Parameters
#
# [*basedir*]
#  Base directory for installation, Default: /opt/twitch
#
# [*user*]
#  User to own directories, Default: jtv
#
# [*group*]
#  Group to own directories, Default: jtv
#
# === Example
# # This example will create the following directories:
# #  /opt/twitch/myservice
# #  /opt/twitch/myservice/etc
# #  /opt/twitch/myservice/releases
# courier::dirs{ 'myservice':}
#
define courier::dirs (
  $basedir = hiera('twitch_basedir','/opt/twitch'),
  $user    = 'jtv',
  $group   = 'jtv',
) {

  $appdir       = "${basedir}/${name}"
  $confdir      = "${appdir}/etc"
  $releasesdir  = "${appdir}/releases"
  $shareddir    = "${appdir}/shared"

  validate_absolute_path($confdir)
  validate_absolute_path($releasesdir)

  file{ $appdir:
    ensure => directory,
    owner  => $user,
    group  => $group,
    mode   => '0775',
  }

  file{ $confdir:
    ensure  => directory,
    owner   => $user,
    group   => $group,
    mode    => '0775',
    require => File[$appdir],
  }

  file{ $releasesdir:
    ensure  => directory,
    owner   => $user,
    group   => $group,
    mode    => '0775',
    require => File[$appdir],
  }

  file{ $shareddir:
    ensure  => directory,
    owner   => $user,
    group   => $group,
    mode    => '0775',
    require => File[$appdir],
  }
}
