require 'spec_helper'

describe 'courier::dirs', :type => :define do
  let(:title) {'mytest'}
  let(:facts) do {
    :osfamily => 'Debian',
    :lsbdistcodename => 'precise',
    :ipaddress => '127.0.0.1'
  }
  end

  context 'verify set invalid basedir' do
    let(:params) do {
      :basedir => 'tmp', # Should fail with validation of paths
    }
    end

    it do
      expect {
        should compile
      }.to raise_error(Puppet::Error)
    end
  end

  context 'verify defin' do
    let(:params) do {
      :basedir => '/tmp',
      :user    => 'theking',
      :group   => 'royalty',
    }
    end

    let(:appdir) {::File::join(params[:basedir],title)}
    let(:confdir) {::File::join(appdir,'etc')}
    let(:releasesdir) {::File::join(appdir,'releases')}

    it 'should create appdir' do
      expect {
        should contain_file(appdir).with({
          :ensure => 'directory',
          :owner  => params[:user],
          :group  => params[:group],
        })}
    end

    it 'should create confdir' do
      expect {
        should contain_file(confdir).with({
          :ensure => 'directory',
          :owner  => params[:user],
          :group  => params[:group],
        })}
    end

    it 'should create releasesdir' do
      expect {
        should contain_file(releasesdir).with({
          :ensure => 'directory',
          :owner  => params[:user],
          :group  => params[:group],
        })}
    end
  end
end
