require 'spec_helper'

describe 'courier::install', :type => :define do
  let(:title) {'mytest'}
  let(:facts) do {
    :osfamily => 'Debian',
    :lsbdistcodename => 'precise',
    :ipaddress => '127.0.0.1'
  }
  end

  context 'verify not setting extra_flags params' do
    let(:params) do {
      :env         => 'development',
      :repo        => 'test/mytest',
      :basedir     => '/tmp',
      :user        => 'nobody',
      :group       => 'nogroup',
    }
    end

    it do
      expect {
        should compile
      }
    end
  end

  context 'verify valid extra_flags params' do
    let(:params) do {
      :env         => 'development',
      :repo        => 'test/mytest',
      :basedir     => '/tmp',
      :user        => 'nobody',
      :group       => 'nogroup',
      :extra_flags => '--valid-flag value',
    }
    end

    it do
      expect {
        should compile
      }
    end
  end

  context 'verify invalid extra_flags params' do
    let(:params) do {
      :env         => 'development',
      :repo        => 'test/mytest',
      :basedir     => '/tmp',
      :user        => 'nobody',
      :group       => 'nogroup',
      :extra_flags => 'invalid flag', # Missing beginning --
    }
    end

    it do
      expect {
        should compile
      }.to raise_error(Puppet::Error)
    end
  end

  context 'verify tar install' do
    let(:params) do {
      :env     => 'development',
      :repo    => 'test/mytest',
      :basedir => '/tmp',
      :user    => 'nobody',
      :group   => 'nogroup',
    }
    end

  end

  context 'verify docker install failure' do
    let(:params) do {
      :env     => 'development',
      :repo    => 'test/mytest',
      :basedir => '/tmp',
      :user    => 'nobody',
      :group   => 'nogroup',
      :type    => 'invalid',
    }
    end

    it do
      expect {
        should compile
      }.to raise_error(Puppet::Error)
    end
  end

  context 'verify docker install failure' do
    let(:params) do {
      :env     => 'development',
      :repo    => 'test/mytest',
      :basedir => '/tmp',
      :user    => 'nobody',
      :group   => 'nogroup',
      :type    => 'docker',
    }
    end

    it do
      expect {
        should compile
      }.to raise_error(Puppet::Error)
    end
  end

  context 'verify docker install success' do
    let(:params) do {
      :env     => 'development',
      :repo    => 'test/mytest',
      :basedir => '/tmp',
      :user    => 'nobody',
      :group   => 'nogroup',
      :image   => 'myimage',
      :type    => 'docker',
    }
    end

    it do
      expect {
        should compile
      }
    end
  end

  context 'common resources' do
    let(:params) do {
      :env     => 'development',
      :repo    => 'test/mytest',
      :basedir => '/tmp',
      :user    => 'nobody',
      :group   => 'nogroup',
      :type    => 'tar',
    }
    end

    it { should contain_class('courier') }

    it "should have a courier::dirs" do
      should contain_courier__dirs(title).with({
        :basedir => params[:basedir],
        :user    => params[:user],
        :group   => params[:group],
      })
    end
  end
end
