class courierd::config (
  $courierd_config = '/etc/courierd.conf',
) {
  include courierd

  validate_absolute_path($courierd_config)

  $user = $courierd::user

  $clean = hiera('clean', 'false')

  $config_mode = $clean ? {
    'false' => '0444',
    default => '0440',
  }

  concat{ $courierd_config:
    owner  => $user,
    group  => '0',
    mode   => $config_mode,
    notify => Service['courierd'],
  }

  # In case no paths are added, we want concat to not error
  concat::fragment { 'placeholder':
    target    => $courierd_config,
    order    => '01',
    content => "\n",
  }
}
