# == Class: courierd
#
# Installs courierd for managing Twitch code on servers
#
# [*version*]
#  Version of courierd to install, Default: latest
#
# [*user*]
#  User to run service, Default: nobody
#
# [*pub_key*]
#  Path to the courierd config file
class courierd (
  $version = $courierd::params::version,
  $user    = $courierd::params::user,
  $pub_key = $courierd::params::pub_key,
) inherits courierd::params {

  include courierd::config

  package { 'courierd':
    ensure => $version,
    notify => Service['courierd'],
  }

  file{ $pub_key:
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0444',
    source  => 'puppet:///modules/courierd/courierd_key.pub', #Pub key
    require => Package['courierd'],
  }

  daemontools::supervise { "courierd":
    daemon_dir     => '/var/lib/service',
    user           => $user,
    syslog         => local3,
    enable_cgroups => true,
    wd             => '/',
    daemon         => 'courierd 2>&1',
    predaemon      => [
      "export GOMAXPROCS=4"
    ],
    require        => [
      File[$pub_key],
      Class['courierd::config'],
    ],
  }
}
