class daemontools inherits daemontools::params {

  package { $packages: }

  service { 'svscan':
    ensure  => 'running',
    enable  => true,
    require => Package[$packages]
  }

  file { $daemon_dirs:
    ensure  => 'directory',
    require => Package[$packages]
  }

  # helper script to remove services
  file { "/usr/local/bin/remove_service":
    source => "puppet:///modules/${module_name}/remove_service",
    owner  => 'root',
    group  => 'root',
    mode   => 0755,
  }

}
