# Not Brigade is a small API that merges branches together and reports merge
# conflicts. Nothing more nothing less. This is to allow us to build tools on
# top of it to replace brigade.
# 
# Params:
# The http_port is only for reporting purposes and doesnt actually change the running port.
# deploy_environment matches deploy.internal
class not_brigade (
  $app_dir            = $not_brigade::params::app_dir,
  $project            = $not_brigade::params::project,
  $user               = $not_brigade::params::user,
  $deploy_environment = $not_brigade::params::deploy_environment,
  $http_port          = $not_brigade::params::http_port,
) inherits not_brigade::params {
  validate_string($deploy_environment,$http_port)
  include forerunner

  $clean_deploy_env = $::clean ? {
    true    => "clean-${deploy_environment}",
    default => $deploy_environment,
  }

  #  consul::service { 'not-brigade-daemon-deploy':
  #  port           => $http_port,
  #  consul_tags    => [$clean_deploy_env],
  #}

  courier::install{ 'not-brigade':
    env         => $clean_deploy_env,
    repo        => $project,
    basedir     => $base_dir,
    require     => [
      Daemontools::Supervise['not-brigade'],
    ]
  }

  daemontools::supervise { 'not-brigade':
    user      => $user,
    syslog    => "local3",
    predaemon => [
      '# not-brigade',
      '# desc: a go-get not-brigade server and per-project home page.',
      '# owner: devtools@twitch.tv',
      '# url: code.justin.tv/release/not-brigade',
      "export APP=not-brigade",
      "export APPDIR=${app_dir}/current",
      "export ENVIRONMENT=${clean_deploy_env}",
    ],
    physical_cd => true,
    wd          => "$app_dir/current",
    daemon      => "forerunner exec bin/not-brigade 2>&1",
    daemon_dir     => '/var/lib/service',
    require     => Class["forerunner"],
  }
}
